/*:
 * @plugindesc 
 * 注文の情報を管理するプラグイン
 * 
 * @help
 * 注文の情報を管理するプラグイン
 *  
 * @author ekus
 * @version 1.0
 */

class cOrder
{

	//=================================================================================
	//■■■ コンストラクタ ■■■
	//=================================================================================
	constructor()
	{
		this.Init();
	}

	//=================================================================================
	//■■■ 初期化 ■■■
	//=================================================================================
	Init() 
	{
		this.icon		= -1;	//注文の商品
		this.regiId		= -1;	//配達先のレジ番号
		this.eventId	= -1;	//配達先のイベントID

		this.time		= -1;	//調理にかかる時間
		this.timeMax	= -1;	//調理にかかる時間
	}

	//=================================================================================
	//■■■ 設定 ■■■
	//=================================================================================
	Set(icon, time, regi, eventId) 
	{
		this.icon		= icon;
		this.regiId		= regi;
		this.eventId	= eventId;


		//調理にかかる時間を計算
		this.time		= time;
		this.timeMax	= time;
	}
}


(function () 
{
	//===========================================================================================
	//■■■ 注文の追加 ■■■
	//===========================================================================================
	AddOrder = function(icon, time, regi, eventId) 
	{
		for (let i=0; i<Order.length; i++) 
		{
			//「無効な注文を見つけた」
			if(Order[i].icon == -1)
			{
				Order[i].Set(icon, time, regi, eventId)
				break;
			}
		}
	}

	//===========================================================================================
	//■■■ 注文の追加 ■■■
	//===========================================================================================
	AddServedList = function(eventId) 
	{
		for (let i=0; i<ServedList.length; i++) 
		{
			//「無効な注文を見つけた」
			if(ServedList[i] == 0)
			{
				ServedList[i] = eventId;
				break;
			}
		}
	}


	//===========================================================================================
	//■■■ 注文の前詰め ■■■
	//===========================================================================================
	PackOrder = function()
	{
		for (let i=0; i<Order.length-1; i++) 
		{ CopyClass(Order[i], Order[i+1]) }

		Order[Order.length-1].Init;
	}



	//===========================================================================================
	//■■■ 注文の前詰め ■■■
	//===========================================================================================
	hasCompOrderSpace = function()
	{
		//マップ別に確認する完成品を分岐
		switch ($gameMap.mapId()) 
		{
		case 17:
			if(CompOrder[0].icon != -1)
			{ return false ;}
			break;

		case 18:
			if(	CompOrder[0].icon != -1 &&
				CompOrder[1].icon != -1 )
			{ return false ;}
			break;

		case 19:
			if(	CompOrder[0].icon != -1 &&
				CompOrder[1].icon != -1 &&
				CompOrder[2].icon != -1 )
			{ return false ;}
			break;
		}


		return true;
	}





	// グローバルスコープに公開する
	window.cOrder = cOrder;

	//注文の一覧
	window.Order = [	new cOrder(),
						new cOrder(),
						new cOrder(),
						new cOrder(),
						new cOrder(),

						new cOrder(),
						new cOrder(),
						new cOrder(),
						new cOrder(),
						new cOrder()];

	//完成した注文
	window.CompOrder = [new cOrder(),
						new cOrder(),
						new cOrder()];

	//配膳完了した注文
	window.ServedList = [0,0,0, 0,0,0, 0,0,0];

						



})();



